
#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Allocation / Entity"
	SimpleWait ( )
#ENDIF

Declare Function Entity_Create ( ByVal Subject As String ) As Story_Entity_Type

Declare Sub Entity_Destroy ( Entity As Story_Entity_Type )

Declare Sub Multi_Entity_Destroy ( Entity ( Any ) As Story_Entity_Type )

Declare Sub Multi_Entity_Load ( Entity ( Any ) As Story_Entity_Type, ByRef Buffer As String, A As Long = 0 )

Declare Sub Entity_Load ( Entity As Story_Entity_Type, ByRef Buffer As String )

Function Entity_Create ( ByVal Subject As String ) As Story_Entity_Type
	
	Dim As Story_Entity_Type Entity
	
	With Entity
	
		.Raw = Subject
	
		If StrPos ( EQ, Subject ) > 0 Then

			.Element = LCase ( Prefix ( EQ, Subject ) )
			Subject = Suffix ( EQ, Subject )
		
		Else

			.Element = "npc"
	
		End If
	
		If StrPos ( ":", Subject ) > 0 Then
	
			.Count = ValInt ( Prefix ( ":", Subject ) )
			Subject = Suffix ( ":", Subject )
		
		Else
	
			.Count = 1
		
		End If
		
		Dim As String Mode = ""
	
		If StrPos ( SP, Subject ) > 0 Then
			Mode = LCase ( Prefix ( SP, Subject ) )
			Select Case Mode
			Case "mad", "dead"
				.Mode = Mode
				Subject = Suffix ( SP, Subject )
			Case Else
				.Mode = ""
			End Select
		End If
	
		.ID = Subject
	
	End With
	
	Return Entity
	
End Function

Sub Entity_Destroy ( Entity As Story_Entity_Type )
	
	With Entity

		'If .Active > 0 Then
	
			.Raw = ""
			.Element = ""
			.ID = ""
			.Count = 0
			.Mode = ""

			If .Sprite <> 0 Then
				.Sprite = ImageDestroy2 ( .Sprite )
			End If

			If .Scaled <> 0 Then
				.Scaled = ImageDestroy2 ( .Scaled )
		
			End If
			
			.Active = 0
			
		'End If
		
	End With
	
End Sub

Sub Multi_Entity_Destroy ( Entity ( Any ) As Story_Entity_Type )
	
	Dim As Long Index = 0
	
	For Index = 0 To UBound ( Entity, 1 ) Step 1
		
		If Entity ( Index ) .Active > 0 Then
			
			Entity_Destroy ( Entity ( Index ) )
			
			'Entity ( Index ) .Active = 0
			
		End If
		
	Next Index

	Erase Entity
	ReDim Entity ( -1 To -1 )

End Sub

Sub Multi_Entity_Load ( Entity ( Any ) As Story_Entity_Type, ByRef Buffer As String, A As Long = 0 )

	Dim As Long Index = 0
	
	/' Entities ( Non-Player Characters + Items ) '/

		ReDim .Entity ( 0 To A - 1 )
	
		For Index = 0 To Ubound ( Entity, 1 ) Step 1
			
			Entity_Load ( Entity ( Index ), Buffer )

		Next Index

End Sub

Sub Entity_Load ( Entity As Story_Entity_Type, ByRef Buffer As String )

	Dim As String Dat
	Dat = ""
	
	/' Entities ( Non-Player Characters + Items ) '/

	With Entity
	
			Dat = Prefix ( CRLF, Buffer )
			Buffer = Suffix ( CRLF, Buffer )
				
			.Raw = Trim ( Trim ( Dat, QUOT ), SP )
		
			Entity = Entity_Create ( .Raw )

			.Active = 1
				
	End With
	
End Sub
